<?php

/**
 * Kunena Plugin
 * @package Kunena.Plugins
 * @subpackage Community
 * 
 * @copyright (C) 2013 iJoomla, Inc. - All rights reserved. Forked from Kunena Team
 * @license GNU General Public License, version 2 (http://www.gnu.org/licenses/gpl-2.0.html)
 * @author iJoomla.com <webmaster@ijoomla.com>
 * @url https://www.jomsocial.com/license-agreement
 * @link http://www.kunena.org
 * The PHP code portions are distributed under the GPL license. If not otherwise stated, all images, manuals, cascading style sheets, and included JavaScript *are NOT GPL, and are released under the IJOOMLA Proprietary Use License v1.0
 * More info at https://www.jomsocial.com/license-agreement
 */
defined('_JEXEC') or die('Restricted access');

class KunenaActivityCommunity extends KunenaActivity {

    protected $params = null;

    public function __construct($params) {
        $this->params = $params;
    }

    /**
     * 
     * @param type $message
     * @return type
     */
    public function onAfterPost($message) {
        if (JString::strlen($message->message) > $this->params->get('activity_points_limit', 0)) {
            CFactory::load('libraries', 'userpoints');
            CUserPoints::assignPoint('com_kunena.thread.new');
        }

        $parent = new stdClass();
        $parent->forceSecure = true;
        $parent->forceMinimal = true;

        $content = KunenaHtmlParser::parseBBCode($message->message, $parent, $this->params->get('activity_stream_limit', 0));

        // Add readmore permalink
        $content .= '<br /><a rel="nofollow" href="' . $message->getPermaUrl() . '" class="small profile-newsfeed-item-action">' . JText::_('COM_KUNENA_READMORE') . '</a>';

        $act = new stdClass ();
        $act->cmd = 'wall.write';
        $act->actor = $message->userid;
        $act->target = 0; // no target
        $act->title = JText::_('{actor} ' . JText::sprintf('PLG_KUNENA_COMMUNITY_ACTIVITY_POST_TITLE', ' <a href="' . $message->getTopic()->getUrl() . '">' . $message->subject . '</a>'));
        $act->content = $content;
        $act->app = 'kunena.thread.post';
        $act->cid = $message->thread;
        $act->access = $this->getAccess($message->getCategory());

        // Comments and like support
        $act->comment_id = $message->thread;
        $act->comment_type = 'kunena.thread.post';
        $act->like_id = $message->thread;
        $act->like_type = 'kunena.thread.post';

        // Do not add private activities
        if ($act->access > 20)
            return;
        CFactory::load('libraries', 'activities');
        CActivityStream::add($act);
    }

    /**
     * 
     * @param type $message
     * @return type
     */
    public function onAfterReply($message) {
        if (JString::strlen($message->message) > $this->params->get('activity_points_limit', 0)) {
            CFactory::load('libraries', 'userpoints');
            CUserPoints::assignPoint('com_kunena.thread.reply');
        }

        $parent = new stdClass();
        $parent->forceSecure = true;
        $parent->forceMinimal = true;

        $content = KunenaHtmlParser::parseBBCode($message->message, $parent, $this->params->get('activity_stream_limit', 0));

        // Add readmore permalink
        $content .= '<br /><a rel="nofollow" href="' . $message->getPermaUrl() . '" class="small profile-newsfeed-item-action">' . JText::_('COM_KUNENA_READMORE') . '</a>';

        /**
         * Notification
         */
        /**
         * Adds notification data into the mailq table
         * @param type $command
         * @param null $actorId
         * @param type $recipients
         * @param type $subject
         * @param type $body
         * @param type $templateFile
         * @param type $mailParams
         * @param type $sendEmail
         * @param type $favicon
         * @param type $altSubject
         * @return type
         */
        $command = 'system_messaging';
        $user = CFactory::getUser($message->userid);
        $title = JText::_($user->getDisplayName() . ' ' . JText::sprintf('PLG_KUNENA_COMMUNITY_ACTIVITY_REPLY_TITLE', '<a href="' . $message->getTopic()->getUrl() . '">' . $message->subject . '</a>'));
        $subscribers = $this->_getSubscribers($message);
        $list = array();
        foreach ($subscribers as $subscriber) {
            $list[] = $subscriber->id;
        }
        CNotification::add($command, $message->userid, $list, $title, '');

        /* Activity stream */
        $act = new stdClass ();
        $act->cmd = 'wall.write';
        $act->actor = $message->userid;
        $act->target = 0; // no target
        $act->title = $title;
        $act->content = $content;
        $act->app = 'kunena.thread.reply';
        $act->cid = $message->thread;
        $act->access = $this->getAccess($message->getCategory());

        // Comments and like support
        $act->comment_id = $message->thread;
        $act->comment_type = 'kunena.thread.reply';
        $act->like_id = $message->thread;
        $act->like_type = 'kunena.thread.reply';

        // Do not add private activities
        if ($act->access > 20)
            return;
        CFactory::load('libraries', 'activities');
        CActivityStream::add($act);
    }

    public function onAfterThankyou($target, $actor, $message) {
        CFactory::load('libraries', 'userpoints');
        CUserPoints::assignPoint('com_kunena.thread.thankyou', $target);
        $username = KunenaFactory::getUser($actor)->username;

        $command = 'system_messaging';
        $user = CFactory::getUser();
        $title = JText::_( $user->getDisplayName() . ' ' . JText::sprintf('PLG_KUNENA_COMMUNITY_ACTIVITY_THANKYOU_TITLE', $username, ' <a href="' . $message->getPermaUrl() . '">' . $message->subject . '</a>'));
        CNotification::add($command, $user->id, $message->userid, $title, '');

        $act = new stdClass ();
        $act->cmd = 'wall.write';
        $act->actor = $user->id;
        $act->target = $target;
        $act->title = $title;
        $act->content = NULL;
        $act->app = 'kunena.message.thankyou';
        $act->cid = $target;
        $act->access = $this->getAccess($message->getCategory());

        // Comments and like support
        $act->comment_id = $target;
        $act->comment_type = 'kunena.message.thankyou';
        $act->like_id = $target;
        $act->like_type = 'kunena.message.thankyou';

        // Do not add private activities
        if ($act->access > 20)
            return;
        CFactory::load('libraries', 'activities');
        CActivityStream::add($act);
    }

    public function onAfterDeleteTopic($target) {
        CFactory::load('libraries', 'activities');
        CActivityStream::remove('kunena.thread.post', $target->id);
        /**
         * @todo Need get replied id
         */
        CActivityStream::remove('kunena.thread.replied', $target->id);
    }

    protected function getAccess($category) {
        // Activity access level: 0 = public, 20 = registered, 30 = friend, 40 = private
        $accesstype = $category->accesstype;
        if ($accesstype != 'joomla.group' && $accesstype != 'joomla.level') {
            // Private
            return 40;
        }
        if (version_compare(JVERSION, '1.6', '>')) {
            // Joomla 1.6+
            // FIXME: Joomla 1.6 can mix up groups and access levels
            if (($accesstype == 'joomla.level' && $category->access == 1) || ($accesstype == 'joomla.group' && ($category->pub_access == 1 || $category->admin_access == 1))) {
                // Public
                $access = 0;
            } elseif (($accesstype == 'joomla.level' && $category->access == 2) || ($accesstype == 'joomla.group' && ($category->pub_access == 2 || $category->admin_access == 2))) {
                // Registered
                $access = 20;
            } else {
                // Other groups (=private)
                $access = 40;
            }
        } else {
            // Joomla 1.5
            // Joomla access levels: 0 = public,  1 = registered
            // Joomla user groups:  29 = public, 18 = registered
            if (($accesstype == 'joomla.level' && $category->access == 0) || ($accesstype == 'joomla.group' && ($category->pub_access == 0 || $category->pub_access == 29 || $category->admin_access == 29))) {
                // Public
                $access = 0;
            } elseif (($accesstype == 'joomla.level' && $category->access == 1) || ($accesstype == 'joomla.group' && ($category->pub_access == -1 || $category->pub_access == 18 || $category->admin_access == 18))) {
                // Registered
                $access = 20;
            } else {
                // Other groups (=private)
                $access = 40;
            }
        }
        return $access;
    }

    /**
     * 
     * @param type $message
     * @return type
     */
    private function _getSubscribers($message) {
        $acl = KunenaAccess::getInstance();
        /* exclude myself - of course */
        $excludeList[] = $message->userid;
        /* get subscribers */
        $subscribers = $acl->getSubscribers($message->catid, $message->thread, KunenaAccess::TOPIC_SUBSCRIPTION, 0, 0, $excludeList);
        return $subscribers;
    }

}
